using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace jerk_off
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;
        Texture2D textureHandDown;
        Texture2D textureHandUp;
        Texture2D textureScore;
		Texture2D textureWin1;
		Texture2D textureWin2;
		Texture2D textureWin3;
		Texture2D textureCount1;
		Texture2D textureCount2;
		Texture2D textureCount3;
		Texture2D textureGameScreen;
		Texture2D textureLobby;
		Texture2D textureLobby1;
		Texture2D textureLobby2;
        KeyboardState keyboardState = Keyboard.GetState();
        Player[] players= new Player[2];
        const int max_score = 1000;
        char mode = 'L';
		int winner = -1;
		double modeStartTimeMiliseconds;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
			graphics.IsFullScreen = true;
			graphics.PreferredBackBufferWidth = 1920;
			graphics.PreferredBackBufferHeight = 1080;
            Content.RootDirectory = "Content";
            for (int a = 0; a < 2; a++)
                players[a] = new Player();
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            // TODO: Add your initialization logic here

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);
            textureHandDown = Content.Load<Texture2D>("hand_down");
            textureHandUp = Content.Load<Texture2D>("hand_up");
            textureScore = Content.Load<Texture2D>("score");
			textureWin1 = Content.Load<Texture2D>("win1");
			textureWin2 = Content.Load<Texture2D>("win2");
			textureWin3 = Content.Load<Texture2D>("win3");
			textureCount1 = Content.Load<Texture2D>("count1");
			textureCount2 = Content.Load<Texture2D>("count2");
			textureCount3 = Content.Load<Texture2D>("count3");
			textureGameScreen = Content.Load<Texture2D>("game_screen");
			textureLobby = Content.Load<Texture2D>("lobby");
			textureLobby1 = Content.Load<Texture2D>("lobby1");
			textureLobby2 = Content.Load<Texture2D>("lobby2");
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            keyboardState = Keyboard.GetState();

			switch (mode)
			{
				/// lobby
				case 'L':
					{
						if (keyboardState.IsKeyDown(Keys.W) )
						{
							players[0].is_ready = true;
						}
						if (keyboardState.IsKeyDown(Keys.S))
						{
							players[0].is_ready = false;
						}
						if (keyboardState.IsKeyDown(Keys.Up))
						{
							players[1].is_ready = true;
						}
						if (keyboardState.IsKeyDown(Keys.Down))
						{
							players[1].is_ready = false;
						}
						if (players[0].is_ready && players[1].is_ready)
						{
							reset();
							modeStartTimeMiliseconds = gameTime.TotalGameTime.TotalMilliseconds;
						}
					} break;
				/// count down
				case 'C':
					{
						if ( 3000 < (gameTime.TotalGameTime.TotalMilliseconds - modeStartTimeMiliseconds))
						{
							mode = 'G';
							modeStartTimeMiliseconds = gameTime.TotalGameTime.TotalMilliseconds;
						}
					}break;
				/// game
				case 'G':
					{
						if (keyboardState.IsKeyDown(Keys.S) && !keyboardState.IsKeyDown(Keys.W))
						{
							/// move down
							players[0].move_down();
						}
						if (keyboardState.IsKeyDown(Keys.W) && !keyboardState.IsKeyDown(Keys.S))
						{
							/// move up
							players[0].move_up();
						}
						if (keyboardState.IsKeyDown(Keys.Down) && !keyboardState.IsKeyDown(Keys.Up))
						{
							/// move down
							players[1].move_down();
						}
						if (keyboardState.IsKeyDown(Keys.Up) && !keyboardState.IsKeyDown(Keys.Down))
						{
							/// move up
							players[1].move_up();
						}
						/// select winner if there is one
						for (int p = 0; p < 2; p++)
						{
							if (max_score < players[p].score)
							{
								mode = 'W';
								winner = p;
								modeStartTimeMiliseconds = gameTime.TotalGameTime.TotalMilliseconds;
							}
						}
					} break;
				case 'W':
					{
						if ( 10000.0 < gameTime.TotalGameTime.TotalMilliseconds - modeStartTimeMiliseconds)
						{
							players[0].is_ready = false;
							players[1].is_ready = false;
							modeStartTimeMiliseconds = gameTime.TotalGameTime.TotalMilliseconds;
							mode = 'L';
						}
					}break;
			}

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.CornflowerBlue);

            spriteBatch.Begin();

            switch(mode){
				case 'L':{
						spriteBatch.Draw(textureLobby, new Rectangle(0, 0, graphics.GraphicsDevice.Viewport.Width, graphics.GraphicsDevice.Viewport.Height), Color.White);
						for (int p = 0; p < 2; p++)
                        {
							Texture2D texture = (players[p].is_ready) ? textureLobby2 : textureLobby1;
                            if (p == 0)
                                spriteBatch.Draw(texture, new Rectangle(0, 0, graphics.GraphicsDevice.Viewport.Width / 2, graphics.GraphicsDevice.Viewport.Height), Color.White);
                            else
                                spriteBatch.Draw(texture, new Rectangle(graphics.GraphicsDevice.Viewport.Width / 2, 0, graphics.GraphicsDevice.Viewport.Width / 2, graphics.GraphicsDevice.Viewport.Height), Color.White);
                        }
					}break;
				case 'C':
					{
						//// count down
						Texture2D texture = textureCount3;
						if ( (gameTime.TotalGameTime.TotalMilliseconds - modeStartTimeMiliseconds) < 1000 )
						{
							texture = textureCount3;
						}
						else if ((gameTime.TotalGameTime.TotalMilliseconds - modeStartTimeMiliseconds) < 2000)
						{
							texture = textureCount2;
						}
						else if ((gameTime.TotalGameTime.TotalMilliseconds - modeStartTimeMiliseconds) < 3000)
						{
							texture = textureCount1;
						}
						spriteBatch.Draw(texture, new Rectangle(0, 0, graphics.GraphicsDevice.Viewport.Width/2, graphics.GraphicsDevice.Viewport.Height), Color.White);
						spriteBatch.Draw(texture, new Rectangle(graphics.GraphicsDevice.Viewport.Width / 2, 0, graphics.GraphicsDevice.Viewport.Width / 2, graphics.GraphicsDevice.Viewport.Height), Color.White);
						spriteBatch.Draw(textureGameScreen, new Rectangle(0, 0, graphics.GraphicsDevice.Viewport.Width, graphics.GraphicsDevice.Viewport.Height), Color.White);
					}break;
                case 'G':
                    {
						for (int p = 0; p < 2; p++)
                        {
                            Texture2D texture = (players[p].score % 2 == 0) ? textureHandDown : textureHandUp;
                            if (p == 0)
                                spriteBatch.Draw(texture, new Rectangle(0, 0, graphics.GraphicsDevice.Viewport.Width / 2, graphics.GraphicsDevice.Viewport.Height), Color.White);
                            else
                                spriteBatch.Draw(texture, new Rectangle(graphics.GraphicsDevice.Viewport.Width / 2, 0, graphics.GraphicsDevice.Viewport.Width / 2, graphics.GraphicsDevice.Viewport.Height), Color.White);
                            spriteBatch.Draw(textureScore, new Rectangle(graphics.GraphicsDevice.Viewport.Width / 2 - 5 + p * 10 - 5, graphics.GraphicsDevice.Viewport.Height * (max_score - players[p].score) / max_score, 10, graphics.GraphicsDevice.Viewport.Height * players[p].score / max_score), Color.White);
                        }
						spriteBatch.Draw(textureGameScreen, new Rectangle(0, 0, graphics.GraphicsDevice.Viewport.Width, graphics.GraphicsDevice.Viewport.Height), Color.White);
                    }break;
				case 'W':
					{
						Texture2D texture = textureWin1;
						if ( 500 < (gameTime.TotalGameTime.TotalMilliseconds - modeStartTimeMiliseconds) )
						{
							if ((gameTime.TotalGameTime.TotalMilliseconds - modeStartTimeMiliseconds) % 1000 > 500)
							{
								texture = textureWin2;
							}
							else
							{
								texture = textureWin3;
							}
						}
						SpriteEffects myEffect = SpriteEffects.FlipHorizontally;
						if( winner==0 )
							spriteBatch.Draw(texture, new Rectangle(0, 0, graphics.GraphicsDevice.Viewport.Width, graphics.GraphicsDevice.Viewport.Height), Color.White);
						else
							spriteBatch.Draw(texture, new Rectangle(0, 0, graphics.GraphicsDevice.Viewport.Width, graphics.GraphicsDevice.Viewport.Height), new Rectangle(0, 0, texture.Width, texture.Height), Color.White, 0.0f, new Vector2(0, 0), myEffect, 0.0f);
					}break;
            }

            spriteBatch.End();

            base.Draw(gameTime);
        }

		private void reset()
		{
			for (int p = 0; p < 2; p++)
			{
				players[p].score = 0;
				mode = 'C';
			}
		}
    }
}
